clear();
clc();
close all;                              %Plots schlieen

%KONFIGURATION---------------------------------------------------------------------
Y                   = @(x) (10*x)+2;  %Gleichung eingeben (innerhalb Integral)
obereGrenze         = 3.0;              %b
untereGrenze        = 0.0;              %a
Quantisierung       = 8;                %n
sKommastellenDouble = '%.8f';           %Nachkommastellen, die in einer Berechnung mitgeschleift werden sollen

%INITIALISIERUNG-------------------------------------------------------------------
aWERTETABELLE(1,:)=["i","Xi","F(untereGrenze)","F(ungerade)","F(gerade)","F(obereGrenze)"];

%BERECHNUNG------------------------------------------------------------------------
dSCHRITTWEITE=(obereGrenze-untereGrenze)/Quantisierung;
for(i=0:1:Quantisierung)
    aWERTETABELLE(i+2,1)=num2str(i);
    if(i==0)
        aWERTETABELLE(i+2,2)=num2str(untereGrenze);
    else
        aWERTETABELLE(i+2,2)=num2str(str2double(aWERTETABELLE(i+1,2))+dSCHRITTWEITE,sKommastellenDouble);        
    end
    switch(i)
        case 0
            aWERTETABELLE(i+2,3)=num2str(Y(untereGrenze),sKommastellenDouble);
            aWERTETABELLE(i+2,4)="";
            aWERTETABELLE(i+2,5)="";
            aWERTETABELLE(i+2,6)="";
        case Quantisierung
            aWERTETABELLE(i+2,3)="";
            aWERTETABELLE(i+2,4)="";
            aWERTETABELLE(i+2,5)="";
            aWERTETABELLE(i+2,6)=num2str(Y(obereGrenze),sKommastellenDouble);
        otherwise
            if(mod(i,2)==1)
                aWERTETABELLE(i+2,3)="";
                aWERTETABELLE(i+2,4)=num2str(Y(str2double(aWERTETABELLE(i+2,2))),sKommastellenDouble);
                aWERTETABELLE(i+2,5)="";
                aWERTETABELLE(i+2,6)="";
            else
                aWERTETABELLE(i+2,3)="";
                aWERTETABELLE(i+2,4)="";
                aWERTETABELLE(i+2,5)=num2str(Y(str2double(aWERTETABELLE(i+2,2))),sKommastellenDouble);
                aWERTETABELLE(i+2,6)="";
            end
    end
end
aWERTETABELLE(size(aWERTETABELLE,1)+1,:)="";
aWERTETABELLE(size(aWERTETABELLE,1)+1,1:2)=["Summen = ",""];
Zwischenspeicher(1:2)=0;
for(i=1:1:Quantisierung-1)
    if(mod(i,2)==1)
        Zwischenspeicher(1)=Zwischenspeicher(1)+str2double(aWERTETABELLE(i+2,4));
    else
        Zwischenspeicher(2)=Zwischenspeicher(2)+str2double(aWERTETABELLE(i+2,5));
    end
end
aWERTETABELLE(size(aWERTETABELLE,1),3)=aWERTETABELLE(2,3);
aWERTETABELLE(size(aWERTETABELLE,1),4)=num2str(Zwischenspeicher(1),sKommastellenDouble);
aWERTETABELLE(size(aWERTETABELLE,1),5)=num2str(Zwischenspeicher(2),sKommastellenDouble);
aWERTETABELLE(size(aWERTETABELLE,1),6)=aWERTETABELLE(2+Quantisierung,6);
aWERTETABELLE(size(aWERTETABELLE,1)+1,1)=["Integral = "];
aWERTETABELLE(size(aWERTETABELLE,1),2)=strcat("((",num2str(obereGrenze),"-",num2str(untereGrenze),")","/","(3"," * ",num2str(Quantisierung),"))*");
aWERTETABELLE(size(aWERTETABELLE,1),3)=strcat("(",aWERTETABELLE(size(aWERTETABELLE,1)-1,3));
aWERTETABELLE(size(aWERTETABELLE,1),4)=strcat(" + ","(4 * ",aWERTETABELLE(size(aWERTETABELLE,1)-1,4),")");
aWERTETABELLE(size(aWERTETABELLE,1),5)=strcat(" + ","(2 * ",aWERTETABELLE(size(aWERTETABELLE,1)-1,5),")");
aWERTETABELLE(size(aWERTETABELLE,1),6)=strcat(" + ",aWERTETABELLE(size(aWERTETABELLE,1)-1,6),")");
aWERTETABELLE(size(aWERTETABELLE,1)+1,1)=["Integral = "];
aWERTETABELLE(size(aWERTETABELLE,1),2)=num2str(((obereGrenze-untereGrenze)/(3*Quantisierung))*...
                                        (str2double(aWERTETABELLE(size(aWERTETABELLE,1)-2,3)) + ...
                                        (4*str2double(aWERTETABELLE(size(aWERTETABELLE,1)-2,4))) + ...
                                        (2*str2double(aWERTETABELLE(size(aWERTETABELLE,1)-2,5))) + ...
                                        str2double(aWERTETABELLE(size(aWERTETABELLE,1)-2,6)) ...
                                        ),sKommastellenDouble);
aWERTETABELLE(size(aWERTETABELLE,1),3:6)="";
disp(aWERTETABELLE);

%PROGRAMMENDE----------------------------------------------------------------------
clearvars -except aWERTETABELLE                               %Workspace aufrumen